Profil = {                   
    MIGUEL    = 57,
    DOREEN    = 139,
    MARTHA    = 109,
    KEITH     = 147,
    YANNI     = 108,
    AUNTIE    = 76,
    MATT      = 148,
    JOEY      = 90,
}

LoyaltyID = {
		-- multiplied by 4.5 due to Omerta's high seniment, so it's 45%
		MIGUEL_READS_LETTER = 1,
		-- +50% bonus for Drassen
		CHILDREN_FREED_DOREEN_KILLED = 2,
		-- -25% for low Cambria sentiment
		MARTHA_WHEN_JOEY_RESCUED = 3,
		-- -25% for low Cambria sentiment
		KEITH_WHEN_HILLBILLY_SOLVED = 4,
		-- +75% higher in Chitzena
		YANNI_WHEN_CHALICE_RETURNED_LOCAL = 5,
		-- for ALL towns!
		YANNI_WHEN_CHALICE_RETURNED_GLOBAL = 6,
		-- Alma's increases reduced by half due to low rebel sentiment
		AUNTIE_WHEN_BLOODCATS_KILLED = 7,
		-- Alma's increases reduced by half due to low rebel sentiment 
		MATT_WHEN_DYNAMO_FREED = 8,
}


function HandleLoyaltyChangeForNPCAction()

    -- Omerta loyalty increases when Miguel receives letter from Enrico
	if ubNPCProfileId == Profil.MIGUEL then
		IncrementTownLoyalty ( LoyaltyID.MIGUEL_READS_LETTER )
	end

	-- having freed the child labourers... she is releasing them herself!
	if ubNPCProfileId == Profil.DOREEN  then
		IncrementTownLoyalty( LoyaltyID.CHILDREN_FREED_DOREEN_KILLED )
	end

    -- if Joey is still alive
	if ubNPCProfileId == Profil.MARTHA then
		if ( CheckMercIsDead(Profil.JOEY) == true ) then 
			IncrementTownLoyalty( LoyaltyID.MARTHA_WHEN_JOEY_RESCUED )
		end
	end

    -- Hillbilly problem solved
	if ubNPCProfileId == Profil.KEITH then
		IncrementTownLoyalty( LoyaltyID.KEITH_WHEN_HILLBILLY_SOLVED )
	end

    -- Chalice of Chance returned to Chitzena
	if  ubNPCProfileId == Profil.YANNI then
	
		IncrementTownLoyalty( LoyaltyID.YANNI_WHEN_CHALICE_RETURNED_LOCAL )
	
		-- NOTE: This affects Chitzena,too, a second time, so first value is discounted for it
		IncrementTownLoyaltyEverywhere( LoyaltyID.YANNI_WHEN_CHALICE_RETURNED_GLOBAL )
	end

    -- Bloodcats killed
	if ubNPCProfileId == Profil.AUNTIE  then
		IncrementTownLoyalty( LoyaltyID.UNTIE_WHEN_BLOODCATS_KILLED )
	end

    -- Brother Dynamo freed
	if ubNPCProfileId == Profil.MATT then
		IncrementTownLoyalty( LoyaltyID.MATT_WHEN_DYNAMO_FREED )
	end	

end